import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListApprovalRuleTemplatesCommand, se_ListApprovalRuleTemplatesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ListApprovalRuleTemplatesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "ListApprovalRuleTemplates", {})
    .n("CodeCommitClient", "ListApprovalRuleTemplatesCommand")
    .f(void 0, void 0)
    .ser(se_ListApprovalRuleTemplatesCommand)
    .de(de_ListApprovalRuleTemplatesCommand)
    .build() {
}
