import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetMergeConflictsCommand, se_GetMergeConflictsCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetMergeConflictsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetMergeConflicts", {})
    .n("CodeCommitClient", "GetMergeConflictsCommand")
    .f(void 0, void 0)
    .ser(se_GetMergeConflictsCommand)
    .de(de_GetMergeConflictsCommand)
    .build() {
}
