import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteApprovalRuleTemplateCommand, se_DeleteApprovalRuleTemplateCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DeleteApprovalRuleTemplateCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "DeleteApprovalRuleTemplate", {})
    .n("CodeCommitClient", "DeleteApprovalRuleTemplateCommand")
    .f(void 0, void 0)
    .ser(se_DeleteApprovalRuleTemplateCommand)
    .de(de_DeleteApprovalRuleTemplateCommand)
    .build() {
}
