import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_CreateUnreferencedMergeCommitCommand, se_CreateUnreferencedMergeCommitCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateUnreferencedMergeCommitCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "CreateUnreferencedMergeCommit", {})
    .n("CodeCommitClient", "CreateUnreferencedMergeCommitCommand")
    .f(void 0, void 0)
    .ser(se_CreateUnreferencedMergeCommitCommand)
    .de(de_CreateUnreferencedMergeCommitCommand)
    .build() {
}
