import { createAggregatedClient } from "@smithy/smithy-client";
import { CodeCommitClient } from "./CodeCommitClient";
import { AssociateApprovalRuleTemplateWithRepositoryCommand, } from "./commands/AssociateApprovalRuleTemplateWithRepositoryCommand";
import { BatchAssociateApprovalRuleTemplateWithRepositoriesCommand, } from "./commands/BatchAssociateApprovalRuleTemplateWithRepositoriesCommand";
import { BatchDescribeMergeConflictsCommand, } from "./commands/BatchDescribeMergeConflictsCommand";
import { BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand, } from "./commands/BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand";
import { BatchGetCommitsCommand, } from "./commands/BatchGetCommitsCommand";
import { BatchGetRepositoriesCommand, } from "./commands/BatchGetRepositoriesCommand";
import { CreateApprovalRuleTemplateCommand, } from "./commands/CreateApprovalRuleTemplateCommand";
import { CreateBranchCommand, } from "./commands/CreateBranchCommand";
import { CreateCommitCommand, } from "./commands/CreateCommitCommand";
import { CreatePullRequestApprovalRuleCommand, } from "./commands/CreatePullRequestApprovalRuleCommand";
import { CreatePullRequestCommand, } from "./commands/CreatePullRequestCommand";
import { CreateRepositoryCommand, } from "./commands/CreateRepositoryCommand";
import { CreateUnreferencedMergeCommitCommand, } from "./commands/CreateUnreferencedMergeCommitCommand";
import { DeleteApprovalRuleTemplateCommand, } from "./commands/DeleteApprovalRuleTemplateCommand";
import { DeleteBranchCommand, } from "./commands/DeleteBranchCommand";
import { DeleteCommentContentCommand, } from "./commands/DeleteCommentContentCommand";
import { DeleteFileCommand } from "./commands/DeleteFileCommand";
import { DeletePullRequestApprovalRuleCommand, } from "./commands/DeletePullRequestApprovalRuleCommand";
import { DeleteRepositoryCommand, } from "./commands/DeleteRepositoryCommand";
import { DescribeMergeConflictsCommand, } from "./commands/DescribeMergeConflictsCommand";
import { DescribePullRequestEventsCommand, } from "./commands/DescribePullRequestEventsCommand";
import { DisassociateApprovalRuleTemplateFromRepositoryCommand, } from "./commands/DisassociateApprovalRuleTemplateFromRepositoryCommand";
import { EvaluatePullRequestApprovalRulesCommand, } from "./commands/EvaluatePullRequestApprovalRulesCommand";
import { GetApprovalRuleTemplateCommand, } from "./commands/GetApprovalRuleTemplateCommand";
import { GetBlobCommand } from "./commands/GetBlobCommand";
import { GetBranchCommand } from "./commands/GetBranchCommand";
import { GetCommentCommand } from "./commands/GetCommentCommand";
import { GetCommentReactionsCommand, } from "./commands/GetCommentReactionsCommand";
import { GetCommentsForComparedCommitCommand, } from "./commands/GetCommentsForComparedCommitCommand";
import { GetCommentsForPullRequestCommand, } from "./commands/GetCommentsForPullRequestCommand";
import { GetCommitCommand } from "./commands/GetCommitCommand";
import { GetDifferencesCommand, } from "./commands/GetDifferencesCommand";
import { GetFileCommand } from "./commands/GetFileCommand";
import { GetFolderCommand } from "./commands/GetFolderCommand";
import { GetMergeCommitCommand, } from "./commands/GetMergeCommitCommand";
import { GetMergeConflictsCommand, } from "./commands/GetMergeConflictsCommand";
import { GetMergeOptionsCommand, } from "./commands/GetMergeOptionsCommand";
import { GetPullRequestApprovalStatesCommand, } from "./commands/GetPullRequestApprovalStatesCommand";
import { GetPullRequestCommand, } from "./commands/GetPullRequestCommand";
import { GetPullRequestOverrideStateCommand, } from "./commands/GetPullRequestOverrideStateCommand";
import { GetRepositoryCommand, } from "./commands/GetRepositoryCommand";
import { GetRepositoryTriggersCommand, } from "./commands/GetRepositoryTriggersCommand";
import { ListApprovalRuleTemplatesCommand, } from "./commands/ListApprovalRuleTemplatesCommand";
import { ListAssociatedApprovalRuleTemplatesForRepositoryCommand, } from "./commands/ListAssociatedApprovalRuleTemplatesForRepositoryCommand";
import { ListBranchesCommand, } from "./commands/ListBranchesCommand";
import { ListFileCommitHistoryCommand, } from "./commands/ListFileCommitHistoryCommand";
import { ListPullRequestsCommand, } from "./commands/ListPullRequestsCommand";
import { ListRepositoriesCommand, } from "./commands/ListRepositoriesCommand";
import { ListRepositoriesForApprovalRuleTemplateCommand, } from "./commands/ListRepositoriesForApprovalRuleTemplateCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { MergeBranchesByFastForwardCommand, } from "./commands/MergeBranchesByFastForwardCommand";
import { MergeBranchesBySquashCommand, } from "./commands/MergeBranchesBySquashCommand";
import { MergeBranchesByThreeWayCommand, } from "./commands/MergeBranchesByThreeWayCommand";
import { MergePullRequestByFastForwardCommand, } from "./commands/MergePullRequestByFastForwardCommand";
import { MergePullRequestBySquashCommand, } from "./commands/MergePullRequestBySquashCommand";
import { MergePullRequestByThreeWayCommand, } from "./commands/MergePullRequestByThreeWayCommand";
import { OverridePullRequestApprovalRulesCommand, } from "./commands/OverridePullRequestApprovalRulesCommand";
import { PostCommentForComparedCommitCommand, } from "./commands/PostCommentForComparedCommitCommand";
import { PostCommentForPullRequestCommand, } from "./commands/PostCommentForPullRequestCommand";
import { PostCommentReplyCommand, } from "./commands/PostCommentReplyCommand";
import { PutCommentReactionCommand, } from "./commands/PutCommentReactionCommand";
import { PutFileCommand } from "./commands/PutFileCommand";
import { PutRepositoryTriggersCommand, } from "./commands/PutRepositoryTriggersCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { TestRepositoryTriggersCommand, } from "./commands/TestRepositoryTriggersCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateApprovalRuleTemplateContentCommand, } from "./commands/UpdateApprovalRuleTemplateContentCommand";
import { UpdateApprovalRuleTemplateDescriptionCommand, } from "./commands/UpdateApprovalRuleTemplateDescriptionCommand";
import { UpdateApprovalRuleTemplateNameCommand, } from "./commands/UpdateApprovalRuleTemplateNameCommand";
import { UpdateCommentCommand, } from "./commands/UpdateCommentCommand";
import { UpdateDefaultBranchCommand, } from "./commands/UpdateDefaultBranchCommand";
import { UpdatePullRequestApprovalRuleContentCommand, } from "./commands/UpdatePullRequestApprovalRuleContentCommand";
import { UpdatePullRequestApprovalStateCommand, } from "./commands/UpdatePullRequestApprovalStateCommand";
import { UpdatePullRequestDescriptionCommand, } from "./commands/UpdatePullRequestDescriptionCommand";
import { UpdatePullRequestStatusCommand, } from "./commands/UpdatePullRequestStatusCommand";
import { UpdatePullRequestTitleCommand, } from "./commands/UpdatePullRequestTitleCommand";
import { UpdateRepositoryDescriptionCommand, } from "./commands/UpdateRepositoryDescriptionCommand";
import { UpdateRepositoryEncryptionKeyCommand, } from "./commands/UpdateRepositoryEncryptionKeyCommand";
import { UpdateRepositoryNameCommand, } from "./commands/UpdateRepositoryNameCommand";
const commands = {
    AssociateApprovalRuleTemplateWithRepositoryCommand,
    BatchAssociateApprovalRuleTemplateWithRepositoriesCommand,
    BatchDescribeMergeConflictsCommand,
    BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand,
    BatchGetCommitsCommand,
    BatchGetRepositoriesCommand,
    CreateApprovalRuleTemplateCommand,
    CreateBranchCommand,
    CreateCommitCommand,
    CreatePullRequestCommand,
    CreatePullRequestApprovalRuleCommand,
    CreateRepositoryCommand,
    CreateUnreferencedMergeCommitCommand,
    DeleteApprovalRuleTemplateCommand,
    DeleteBranchCommand,
    DeleteCommentContentCommand,
    DeleteFileCommand,
    DeletePullRequestApprovalRuleCommand,
    DeleteRepositoryCommand,
    DescribeMergeConflictsCommand,
    DescribePullRequestEventsCommand,
    DisassociateApprovalRuleTemplateFromRepositoryCommand,
    EvaluatePullRequestApprovalRulesCommand,
    GetApprovalRuleTemplateCommand,
    GetBlobCommand,
    GetBranchCommand,
    GetCommentCommand,
    GetCommentReactionsCommand,
    GetCommentsForComparedCommitCommand,
    GetCommentsForPullRequestCommand,
    GetCommitCommand,
    GetDifferencesCommand,
    GetFileCommand,
    GetFolderCommand,
    GetMergeCommitCommand,
    GetMergeConflictsCommand,
    GetMergeOptionsCommand,
    GetPullRequestCommand,
    GetPullRequestApprovalStatesCommand,
    GetPullRequestOverrideStateCommand,
    GetRepositoryCommand,
    GetRepositoryTriggersCommand,
    ListApprovalRuleTemplatesCommand,
    ListAssociatedApprovalRuleTemplatesForRepositoryCommand,
    ListBranchesCommand,
    ListFileCommitHistoryCommand,
    ListPullRequestsCommand,
    ListRepositoriesCommand,
    ListRepositoriesForApprovalRuleTemplateCommand,
    ListTagsForResourceCommand,
    MergeBranchesByFastForwardCommand,
    MergeBranchesBySquashCommand,
    MergeBranchesByThreeWayCommand,
    MergePullRequestByFastForwardCommand,
    MergePullRequestBySquashCommand,
    MergePullRequestByThreeWayCommand,
    OverridePullRequestApprovalRulesCommand,
    PostCommentForComparedCommitCommand,
    PostCommentForPullRequestCommand,
    PostCommentReplyCommand,
    PutCommentReactionCommand,
    PutFileCommand,
    PutRepositoryTriggersCommand,
    TagResourceCommand,
    TestRepositoryTriggersCommand,
    UntagResourceCommand,
    UpdateApprovalRuleTemplateContentCommand,
    UpdateApprovalRuleTemplateDescriptionCommand,
    UpdateApprovalRuleTemplateNameCommand,
    UpdateCommentCommand,
    UpdateDefaultBranchCommand,
    UpdatePullRequestApprovalRuleContentCommand,
    UpdatePullRequestApprovalStateCommand,
    UpdatePullRequestDescriptionCommand,
    UpdatePullRequestStatusCommand,
    UpdatePullRequestTitleCommand,
    UpdateRepositoryDescriptionCommand,
    UpdateRepositoryEncryptionKeyCommand,
    UpdateRepositoryNameCommand,
};
export class CodeCommit extends CodeCommitClient {
}
createAggregatedClient(commands, CodeCommit);
