"use strict";
// fingerprint config is based on the old skip pr update logic
// https://github.com/renovatebot/renovate/blob/3d85b6048d6a8c57887b64ed4929e2e02ea41aa0/lib/workers/repository/update/pr/index.ts#L294-L306
Object.defineProperty(exports, "__esModule", { value: true });
exports.generatePrBodyFingerprintConfig = generatePrBodyFingerprintConfig;
exports.validatePrCache = validatePrCache;
const logger_1 = require("../../../../logger");
const date_1 = require("../../../../util/date");
function generatePrBodyFingerprintConfig(config) {
    const filteredUpgrades = config.upgrades.map((upgrade) => {
        return {
            depName: upgrade.depName,
            displayFrom: upgrade.displayFrom,
            displayTo: upgrade.displayTo,
            displayPending: upgrade.displayPending,
            gitRef: upgrade.gitRef,
            hasReleaseNotes: upgrade.hasReleaseNotes,
            prBodyDefinitions: upgrade.prBodyDefinitions,
            prBodyNotes: upgrade.prBodyNotes,
            repoName: upgrade.repoName,
        };
    });
    return {
        automerge: config.automerge,
        automergeSchedule: config.automergeSchedule,
        baseBranch: config.baseBranch,
        filteredUpgrades,
        hasReleaseNotes: config.hasReleaseNotes,
        isPin: config.isPin,
        prBodyTemplate: config.prBodyTemplate,
        prFooter: config.prFooter,
        prHeader: config.prHeader,
        prTitle: config.prTitle,
        rebaseWhen: config.rebaseWhen,
        recreateWhen: config.recreateWhen,
        schedule: config.schedule,
        stopUpdating: config.stopUpdating,
        timezone: config.timezone,
        updateType: config.updateType,
        warnings: config.warnings,
        pendingVersions: config.pendingVersions,
    };
}
function validatePrCache(prCache, bodyFingerprint) {
    if (prCache.bodyFingerprint !== bodyFingerprint) {
        logger_1.logger.debug('PR fingerprints mismatch, processing PR');
        return false;
    }
    if ((0, date_1.getElapsedHours)(prCache.lastEdited) < 24) {
        logger_1.logger.debug('PR cache matches but it has been edited in the past 24hrs, so processing PR');
        return false;
    }
    logger_1.logger.debug('PR cache matches and no PR changes in last 24hrs, so skipping PR body check');
    return true;
}
//# sourceMappingURL=pr-fingerprint.js.map