import type { RecreateWhen, UpdateType, ValidationMessage } from '../../../../config/types';
import type { PrCache } from '../../../../util/cache/repository/types';
import type { BranchConfig } from '../../../types';
export interface FilteredBranchUpgradeConfig {
    depName?: string;
    gitRef?: boolean;
    hasReleaseNotes?: boolean;
    prBodyDefinitions?: Record<string, string>;
    prBodyNotes?: string[];
    repoName?: string;
}
export interface PrBodyFingerprintConfig {
    automerge?: boolean;
    baseBranch?: string;
    automergeSchedule?: string[];
    hasReleaseNotes?: boolean;
    isPin?: boolean;
    prBodyTemplate?: string;
    prFooter?: string;
    prHeader?: string;
    prTitle?: string;
    rebaseWhen?: string;
    recreateWhen?: RecreateWhen;
    schedule?: string[];
    stopUpdating?: boolean;
    timezone?: string;
    updateType?: UpdateType;
    warnings?: ValidationMessage[];
    pendingVersions?: string[];
    filteredUpgrades?: FilteredBranchUpgradeConfig[];
}
export declare function generatePrBodyFingerprintConfig(config: BranchConfig): PrBodyFingerprintConfig;
export declare function validatePrCache(prCache: PrCache, bodyFingerprint: string): boolean;
