"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPrCache = getPrCache;
exports.setPrCache = setPrCache;
const logger_1 = require("../../../../logger");
const repository_1 = require("../../../../util/cache/repository");
function getPrCache(branchName) {
    logger_1.logger.trace(`getPrCache()`);
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branchName === branch.branchName);
    const prCache = branch?.prCache;
    if (!prCache) {
        return null;
    }
    // istanbul ignore if
    if (prCache.fingerprint) {
        prCache.bodyFingerprint = prCache.fingerprint;
        delete prCache.fingerprint;
    }
    return prCache;
}
// store the time a PR was last updated
function setPrCache(branchName, bodyFingerprint, prModified) {
    logger_1.logger.debug(`setPrCache()`);
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branchName === branch.branchName);
    if (!branch) {
        logger_1.logger.debug(`setPrCache(): Branch cache not present`);
        return;
    }
    const lastEdited = branch.prCache?.lastEdited;
    branch.prCache = {
        bodyFingerprint,
        // update time when creating new cache or when pr was modified
        lastEdited: lastEdited && !prModified ? lastEdited : new Date().toISOString(),
    };
}
//# sourceMappingURL=pr-cache.js.map