"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitLabChangeLogSource = void 0;
const source_1 = require("../source");
class GitLabChangeLogSource extends source_1.ChangeLogSource {
    constructor() {
        super('gitlab', 'gitlab-tags');
    }
    getAPIBaseUrl(config) {
        return this.getBaseUrl(config) + 'api/v4/';
    }
    getCompareURL(baseUrl, repository, prevHead, nextHead) {
        return `${baseUrl}${repository}/compare/${prevHead}...${nextHead}`;
    }
    hasValidRepository(repository) {
        return repository.split('/').length >= 2;
    }
}
exports.GitLabChangeLogSource = GitLabChangeLogSource;
//# sourceMappingURL=source.js.map