"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.id = void 0;
exports.getReleaseNotesMd = getReleaseNotesMd;
exports.getReleaseList = getReleaseList;
const tslib_1 = require("tslib");
const node_path_1 = tslib_1.__importDefault(require("node:path"));
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const changelog_filename_regex_1 = tslib_1.__importDefault(require("changelog-filename-regex"));
const logger_1 = require("../../../../../../logger");
const schema_1 = require("../../../../../../modules/platform/bitbucket/schema");
const bitbucket_1 = require("../../../../../../util/http/bitbucket");
const url_1 = require("../../../../../../util/url");
const common_1 = require("../common");
exports.id = 'bitbucket-changelog';
const bitbucketHttp = new bitbucket_1.BitbucketHttp(exports.id);
async function getReleaseNotesMd(repository, apiBaseUrl, sourceDirectory) {
    logger_1.logger.trace('bitbucket.getReleaseNotesMd()');
    const repositorySourceURl = (0, url_1.joinUrlParts)(apiBaseUrl, '2.0/repositories', repository, 'src/HEAD', sourceDirectory ?? '');
    const rootFiles = (await bitbucketHttp.getJson(repositorySourceURl, {
        paginate: true,
    }, schema_1.PagedSourceResultsSchema)).body.values;
    const allFiles = rootFiles.filter((f) => f.type === 'commit_file');
    const files = allFiles.filter((f) => changelog_filename_regex_1.default.test(node_path_1.default.basename(f.path)));
    const changelogFile = files
        .sort((a, b) => (0, common_1.compareChangelogFilePath)(a.path, b.path))
        .shift();
    if (is_1.default.nullOrUndefined(changelogFile)) {
        logger_1.logger.trace('no changelog file found');
        return null;
    }
    if (files.length !== 0) {
        logger_1.logger.debug(`Multiple candidates for changelog file, using ${changelogFile.path}`);
    }
    const fileRes = await bitbucketHttp.getText((0, url_1.joinUrlParts)(apiBaseUrl, '2.0/repositories', repository, 'src', changelogFile.commit.hash, changelogFile.path));
    const changelogMd = `${fileRes.body}\n#\n##`;
    return { changelogFile: changelogFile.path, changelogMd };
}
function getReleaseList(_project, _release) {
    logger_1.logger.trace('bitbucket.getReleaseList()');
    logger_1.logger.info('Unsupported Bitbucket Cloud feature.  Skipping release fetching.');
    return [];
}
//# sourceMappingURL=index.js.map