"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPrBody = getPrBody;
const tslib_1 = require("tslib");
const platform_1 = require("../../../../../modules/platform");
const common_1 = require("../../../../../util/common");
const regex_1 = require("../../../../../util/regex");
const string_1 = require("../../../../../util/string");
const template = tslib_1.__importStar(require("../../../../../util/template"));
const url_1 = require("../../../../../util/url");
const errors_warnings_1 = require("../../../errors-warnings");
const changelogs_1 = require("./changelogs");
const config_description_1 = require("./config-description");
const controls_1 = require("./controls");
const footer_1 = require("./footer");
const header_1 = require("./header");
const notes_1 = require("./notes");
const updates_table_1 = require("./updates-table");
function massageUpdateMetadata(config) {
    config.upgrades.forEach((upgrade) => {
        const { homepage, sourceUrl, sourceDirectory, changelogUrl, dependencyUrl, } = upgrade;
        // TODO: types (#22198)
        let depNameLinked = upgrade.depName;
        const primaryLink = homepage ?? sourceUrl ?? dependencyUrl;
        if (primaryLink) {
            depNameLinked = `[${depNameLinked}](${primaryLink})`;
        }
        let sourceRootPath = 'tree/HEAD';
        if (sourceUrl) {
            const sourcePlatform = (0, common_1.detectPlatform)(sourceUrl);
            if (sourcePlatform === 'bitbucket') {
                sourceRootPath = 'src/HEAD';
            }
            else if (sourcePlatform === 'bitbucket-server') {
                sourceRootPath = 'browse';
            }
        }
        const otherLinks = [];
        if (sourceUrl && (!!sourceDirectory || homepage)) {
            otherLinks.push(`[source](${getFullSourceUrl(sourceUrl, sourceRootPath, sourceDirectory)})`);
        }
        const templatedChangelogUrl = changelogUrl
            ? template.compile(changelogUrl, upgrade, true)
            : undefined;
        if (templatedChangelogUrl) {
            otherLinks.push(`[changelog](${templatedChangelogUrl})`);
        }
        if (otherLinks.length) {
            depNameLinked += ` (${otherLinks.join(', ')})`;
        }
        upgrade.depNameLinked = depNameLinked;
        const references = [];
        if (homepage) {
            references.push(`[homepage](${homepage})`);
        }
        if (sourceUrl) {
            references.push(`[source](${getFullSourceUrl(sourceUrl, sourceRootPath, sourceDirectory)})`);
        }
        if (templatedChangelogUrl) {
            references.push(`[changelog](${templatedChangelogUrl})`);
        }
        upgrade.references = references.join(', ');
    });
}
function getFullSourceUrl(sourceUrl, sourceRootPath, sourceDirectory) {
    let fullUrl = sourceUrl;
    if (sourceDirectory) {
        fullUrl = (0, url_1.joinUrlParts)(sourceUrl, sourceRootPath, sourceDirectory);
    }
    return fullUrl;
}
const rebasingRegex = (0, regex_1.regEx)(/\*\*Rebasing\*\*: .*/);
function getPrBody(branchConfig, prBodyConfig, config) {
    massageUpdateMetadata(branchConfig);
    let warnings = '';
    warnings += (0, errors_warnings_1.getWarnings)(branchConfig);
    if (branchConfig.packageFiles) {
        warnings += (0, errors_warnings_1.getDepWarningsPR)(branchConfig.packageFiles, config, branchConfig.dependencyDashboard);
    }
    const content = {
        header: (0, header_1.getPrHeader)(branchConfig),
        table: (0, updates_table_1.getPrUpdatesTable)(branchConfig),
        warnings,
        notes: (0, notes_1.getPrNotes)(branchConfig) + (0, notes_1.getPrExtraNotes)(branchConfig),
        changelogs: (0, changelogs_1.getChangelogs)(branchConfig),
        configDescription: (0, config_description_1.getPrConfigDescription)(branchConfig),
        controls: (0, controls_1.getControls)(),
        footer: (0, footer_1.getPrFooter)(branchConfig),
    };
    let prBody = '';
    if (branchConfig.prBodyTemplate) {
        const prBodyTemplate = branchConfig.prBodyTemplate;
        prBody = template.compile(prBodyTemplate, content, false);
        prBody = prBody.trim();
        prBody = prBody.replace((0, regex_1.regEx)(/\n\n\n+/g), '\n\n');
        const prDebugData64 = (0, string_1.toBase64)(JSON.stringify(prBodyConfig.debugData));
        prBody += `\n<!--renovate-debug:${prDebugData64}-->\n`;
        prBody = platform_1.platform.massageMarkdown(prBody, config.rebaseLabel);
        if (prBodyConfig?.rebasingNotice) {
            prBody = prBody.replace(rebasingRegex, `**Rebasing**: ${prBodyConfig.rebasingNotice}`);
        }
    }
    return prBody;
}
//# sourceMappingURL=index.js.map