import type { RenovateConfig } from '../../../../config/types';
import type { BranchStatus } from '../../../../types';
import type { MergeConfidence } from '../../../../util/merge-confidence/types';
export declare function resolveBranchStatus(branchName: string, internalChecksAsSuccess: boolean, ignoreTests?: boolean): Promise<BranchStatus>;
export interface StabilityConfig extends RenovateConfig {
    stabilityStatus?: BranchStatus;
    branchName: string;
}
export declare function setStability(config: StabilityConfig): Promise<void>;
export interface ConfidenceConfig extends RenovateConfig {
    confidenceStatus?: BranchStatus;
    minimumConfidence?: MergeConfidence | undefined;
}
export declare function setConfidence(config: ConfidenceConfig): Promise<void>;
