import type { RenovateConfig } from '../../../config/types';
import type { PackageFile } from '../../../modules/manager/types';
import type { Vulnerability } from './types';
export declare class Vulnerabilities {
    private osvOffline;
    private static readonly datasourceEcosystemMap;
    private constructor();
    private initialize;
    static create(): Promise<Vulnerabilities>;
    appendVulnerabilityPackageRules(config: RenovateConfig, packageFiles: Record<string, PackageFile[]>): Promise<void>;
    fetchVulnerabilities(config: RenovateConfig, packageFiles: Record<string, PackageFile[]>): Promise<Vulnerability[]>;
    private fetchDependencyVulnerabilities;
    private fetchManagerVulnerabilities;
    private fetchManagerPackageFileVulnerabilities;
    private fetchDependencyVulnerability;
    private sortByFixedVersion;
    private sortEvents;
    private isPackageAffected;
    private includedInVersions;
    private includedInRanges;
    private isPackageVulnerable;
    private getFixedVersion;
    private getFixedVersionByEcosystem;
    private getLastAffectedByEcosystem;
    private isVersionGt;
    private isVersionGtOrEq;
    private vulnerabilityToPackageRules;
    private evaluateCvssVector;
    private generatePrBodyNotes;
    private extractSeverityDetails;
}
