"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sortBranches = sortBranches;
const logger_1 = require("../../../logger");
function sortBranches(branches) {
    // Sort branches
    const sortOrder = [
        'pin',
        'digest',
        'patch',
        'minor',
        'major',
        'lockFileMaintenance',
    ];
    logger_1.logger.trace({ branches }, 'branches');
    branches.sort((a, b) => {
        if (a.isVulnerabilityAlert && !b.isVulnerabilityAlert) {
            return -1;
        }
        if (!a.isVulnerabilityAlert && b.isVulnerabilityAlert) {
            return 1;
        }
        // TODO #22198
        const prPriorityDiff = getPrPriority(b) - getPrPriority(a);
        if (prPriorityDiff !== 0) {
            return prPriorityDiff;
        }
        // TODO #22198
        const sortDiff = sortOrder.indexOf(a.updateType) - sortOrder.indexOf(b.updateType);
        if (sortDiff !== 0) {
            return sortDiff;
        }
        // TODO #22198
        // Sort by prTitle if updateType is the same
        return a.prTitle.localeCompare(b.prTitle, undefined, { numeric: true });
    });
}
function getPrPriority(branch) {
    return branch.prPriority ?? 0;
}
//# sourceMappingURL=sort.js.map