"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addReplacementUpdateIfValid = addReplacementUpdateIfValid;
exports.isReplacementRulesConfigured = isReplacementRulesConfigured;
exports.determineNewReplacementName = determineNewReplacementName;
exports.determineNewReplacementValue = determineNewReplacementValue;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const manager_1 = require("../../../../modules/manager");
const allVersioning = tslib_1.__importStar(require("../../../../modules/versioning"));
const template = tslib_1.__importStar(require("../../../../util/template"));
function addReplacementUpdateIfValid(updates, config) {
    const replacementNewName = determineNewReplacementName(config);
    const replacementNewValue = determineNewReplacementValue(config);
    if (config.packageName !== replacementNewName ||
        config.currentValue !== replacementNewValue) {
        updates.push({
            updateType: 'replacement',
            newName: replacementNewName,
            newValue: replacementNewValue,
        });
    }
}
function isReplacementRulesConfigured(config) {
    return (is_1.default.nonEmptyString(config.replacementName) ||
        is_1.default.nonEmptyString(config.replacementNameTemplate) ||
        is_1.default.nonEmptyString(config.replacementVersion) ||
        is_1.default.nonEmptyString(config.replacementVersionTemplate));
}
function determineNewReplacementName(config) {
    if (config.replacementName) {
        return config.replacementName;
    }
    if (config.replacementNameTemplate) {
        return template.compile(config.replacementNameTemplate, config, true);
    }
    return config.packageName;
}
function determineNewReplacementValue(config) {
    const newVersion = getNewVersion(config);
    if (!newVersion) {
        return config.currentValue;
    }
    const versioningApi = allVersioning.get(config.versioning);
    const rangeStrategy = (0, manager_1.getRangeStrategy)(config);
    return versioningApi.getNewValue({
        // TODO #22198
        currentValue: config.currentValue,
        newVersion,
        rangeStrategy: rangeStrategy,
        isReplacement: true,
    });
}
function getNewVersion(config) {
    if (!is_1.default.nullOrUndefined(config.replacementVersion)) {
        return config.replacementVersion;
    }
    if (!is_1.default.nullOrUndefined(config.replacementVersionTemplate)) {
        return template.compile(config.replacementVersionTemplate, config, true);
    }
    return null;
}
//# sourceMappingURL=utils.js.map