"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUpdateType = getUpdateType;
function getUpdateType(config, versioningApi, currentVersion, newVersion) {
    if (versioningApi.isSame &&
        !versioningApi.isSame('major', newVersion, currentVersion)) {
        return 'major';
    }
    if (versioningApi.getMajor(newVersion) >
        versioningApi.getMajor(currentVersion)) {
        return 'major';
    }
    if (versioningApi.getMinor(newVersion) >
        versioningApi.getMinor(currentVersion)) {
        return 'minor';
    }
    return 'patch';
}
//# sourceMappingURL=update-type.js.map