import type { RenovateConfig } from '../../../config/types';
import type { PackageFile } from '../../../modules/manager/types';
import type { BaseBranchCache } from '../../../util/cache/repository/types';
import type { BranchConfig } from '../../types';
import type { WriteUpdateResult } from './write';
export declare const EXTRACT_CACHE_REVISION = 1;
export interface ExtractResult {
    branches: BranchConfig[];
    branchList: string[];
    packageFiles: Record<string, PackageFile[]>;
}
export interface StatsResult {
    fileCount: number;
    depCount: number;
}
export interface Stats {
    managers: Record<string, StatsResult>;
    total: StatsResult;
}
export declare function isCacheExtractValid(baseBranchSha: string, configHash: string, cachedExtract?: BaseBranchCache): boolean;
export declare function extract(config: RenovateConfig, overwriteCache?: boolean): Promise<Record<string, PackageFile[]>>;
export declare function lookup(config: RenovateConfig, packageFiles: Record<string, PackageFile[]>): Promise<ExtractResult>;
export declare function update(config: RenovateConfig, branches: BranchConfig[]): Promise<WriteUpdateResult | undefined>;
