import type { PackageFile } from '../../modules/manager/types';
export declare class PackageFiles {
    private static data;
    static add(baseBranch: string, packageFiles: Record<string, PackageFile[]> | null): void;
    static clear(): void;
    /**
     * Truncates the detected dependencies' section until it fits the available space
     * i.e. It has length smaller than maxLength.
     * This does not mutate the original PackageFiles data
     * Note:  setHeader=false is used for testing purposes only
     *        Mainly for comparing truncated and non-truncated markdown
     * @param maxLength
     * @param setHeader
     */
    static getDashboardMarkdown(maxLength: number, setHeader?: boolean): string;
    /**
     * Generates the "detected dependencies" markdown
     * @param data
     */
    private static getDashboardMarkdownInternal;
    /**
     * Removes the last dependency/entry in the PackageFiles data
     * i.e. the last line in the tobe generated detected dependency section
     * @param data
     * @Returns true if anything that translates to a markdown written line was deleted
     *          otherwise false is returned
     */
    private static pop;
}
