"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getScheduleDesc = getScheduleDesc;
exports.getConfigDesc = getConfigDesc;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../../logger");
const emoji_1 = require("../../../../util/emoji");
const common_1 = require("../common");
function getScheduleDesc(config) {
    logger_1.logger.debug('getScheduleDesc()');
    logger_1.logger.trace({ config });
    if (!config.schedule ||
        config.schedule === 'at any time' ||
        config.schedule[0] === 'at any time') {
        logger_1.logger.debug('No schedule');
        return [];
    }
    const desc = `Run Renovate on following schedule: ${String(config.schedule)}`;
    return [desc];
}
function getDescriptionArray(config) {
    logger_1.logger.debug('getDescriptionArray()');
    logger_1.logger.trace({ config });
    const desc = is_1.default.array(config.description, is_1.default.string)
        ? config.description
        : [];
    return desc.concat(getScheduleDesc(config));
}
function getConfigDesc(config, packageFiles) {
    // TODO: type (#22198)
    const configFile = (0, common_1.getDefaultConfigFileName)(config);
    logger_1.logger.debug('getConfigDesc()');
    logger_1.logger.trace({ config });
    const descriptionArr = getDescriptionArray(config);
    if (!descriptionArr.length) {
        logger_1.logger.debug('No config description found');
        return '';
    }
    logger_1.logger.debug(`Found description array with length:${descriptionArr.length}`);
    let desc = `\n### Configuration Summary\n\nBased on the default config's presets, Renovate will:\n\n`;
    desc += `  - Start dependency updates only once this onboarding PR is merged\n`;
    descriptionArr.forEach((d) => {
        desc += `  - ${d}\n`;
    });
    desc += '\n';
    desc += (0, emoji_1.emojify)(`:abcd: Do you want to change how Renovate upgrades your dependencies?`);
    desc += ` Add your custom config to \`${configFile}\` in this branch${config.onboardingRebaseCheckbox
        ? ' and select the Retry/Rebase checkbox below'
        : ''}. Renovate will update the Pull Request description the next time it runs.`;
    desc += '\n\n---\n';
    return desc;
}
//# sourceMappingURL=config-description.js.map