"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rebaseOnboardingBranch = rebaseOnboardingBranch;
const global_1 = require("../../../../config/global");
const logger_1 = require("../../../../logger");
const scm_1 = require("../../../../modules/platform/scm");
const hash_1 = require("../../../../util/hash");
const common_1 = require("../common");
const commit_message_1 = require("./commit-message");
const config_1 = require("./config");
async function rebaseOnboardingBranch(config, previousConfigHash) {
    logger_1.logger.debug('Checking if onboarding branch needs rebasing');
    // skip platforms that do not support html comments in pr
    const platform = global_1.GlobalConfig.get('platform');
    if (!['github', 'gitea', 'gitlab'].includes(platform)) {
        logger_1.logger.debug(`Skipping rebase as ${platform} does not support html comments`);
        return null;
    }
    const configFile = (0, common_1.getDefaultConfigFileName)(config);
    const contents = await (0, config_1.getOnboardingConfigContents)(config, configFile);
    const currentConfigHash = (0, hash_1.toSha256)(contents);
    if (previousConfigHash === currentConfigHash) {
        logger_1.logger.debug('No rebase needed');
        return null;
    }
    logger_1.logger.debug({ previousConfigHash, currentConfigHash }, 'Rebasing onboarding branch');
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info('DRY-RUN: Would rebase files in onboarding branch');
        return null;
    }
    const commitMessageFactory = new commit_message_1.OnboardingCommitMessageFactory(config, configFile);
    const commitMessage = commitMessageFactory.create();
    // TODO #22198
    return scm_1.scm.commitAndPush({
        baseBranch: config.baseBranch,
        branchName: config.onboardingBranch,
        files: [
            {
                type: 'addition',
                path: configFile,
                contents,
            },
        ],
        message: commitMessage.toString(),
        platformCommit: config.platformCommit,
    });
}
//# sourceMappingURL=rebase.js.map