"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOnboardingBranch = createOnboardingBranch;
const global_1 = require("../../../../config/global");
const logger_1 = require("../../../../logger");
const scm_1 = require("../../../../modules/platform/scm");
const template_1 = require("../../../../util/template");
const common_1 = require("../common");
const commit_message_1 = require("./commit-message");
const config_1 = require("./config");
async function createOnboardingBranch(config) {
    logger_1.logger.debug('createOnboardingBranch()');
    const configFile = (0, common_1.getDefaultConfigFileName)(config);
    // TODO #22198
    const contents = await (0, config_1.getOnboardingConfigContents)(config, configFile);
    logger_1.logger.debug('Creating onboarding branch');
    const commitMessageFactory = new commit_message_1.OnboardingCommitMessageFactory(config, configFile);
    let commitMessage = commitMessageFactory.create().toString();
    if (config.commitBody) {
        commitMessage = `${commitMessage}\n\n${(0, template_1.compile)(config.commitBody, 
        // only allow gitAuthor template value in the commitBody
        { gitAuthor: config.gitAuthor })}`;
        logger_1.logger.trace(`commitMessage: ${commitMessage}`);
    }
    // istanbul ignore if
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info('DRY-RUN: Would commit files to onboarding branch');
        return null;
    }
    return scm_1.scm.commitAndPush({
        baseBranch: config.baseBranch,
        branchName: config.onboardingBranch,
        files: [
            {
                type: 'addition',
                // TODO #22198
                path: configFile,
                contents,
            },
        ],
        message: commitMessage,
        platformCommit: config.platformCommit,
        force: true,
    });
}
//# sourceMappingURL=create.js.map