"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRepoConfig = getRepoConfig;
const branch_1 = require("../onboarding/branch");
const inherited_1 = require("./inherited");
const merge_1 = require("./merge");
// istanbul ignore next
async function getRepoConfig(config_) {
    let config = { ...config_ };
    config.baseBranch = config.defaultBranch;
    config = await (0, inherited_1.mergeInheritedConfig)(config);
    config = await (0, branch_1.checkOnboardingBranch)(config);
    config = await (0, merge_1.mergeRenovateConfig)(config);
    return config;
}
//# sourceMappingURL=config.js.map