"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runRenovateRepoStats = runRenovateRepoStats;
exports.runBranchSummary = runBranchSummary;
const reporting_1 = require("../../../instrumentation/reporting");
const logger_1 = require("../../../logger");
const repository_1 = require("../../../util/cache/repository");
function runRenovateRepoStats(config, prList) {
    const prStats = { total: 0, open: 0, closed: 0, merged: 0 };
    for (const pr of prList) {
        if (pr.title === 'Configure Renovate' ||
            pr.title === config.onboardingPrTitle) {
            continue;
        }
        prStats.total += 1;
        switch (pr.state) {
            case 'merged':
                prStats.merged += 1;
                break;
            case 'closed':
                prStats.closed += 1;
                break;
            case 'open':
                prStats.open += 1;
                break;
            default:
                break;
        }
    }
    logger_1.logger.debug({ stats: prStats }, `Renovate repository PR statistics`);
}
function branchCacheToMetadata({ automerge, baseBranch, baseBranchSha, branchName, isModified, pristine: isPristine, sha: branchSha, }) {
    return {
        automerge,
        baseBranch,
        baseBranchSha,
        branchName,
        branchSha,
        isModified,
        isPristine,
    };
}
function filterDependencyDashboardData(branches) {
    const branchesFiltered = [];
    for (const branch of branches) {
        const upgradesFiltered = [];
        const { branchName, prNo, prTitle, result, upgrades, prBlockedBy } = branch;
        for (const upgrade of upgrades ?? []) {
            const { datasource, depName, displayPending, fixedVersion, currentVersion, currentValue, currentDigest, newValue, newVersion, newDigest, packageFile, updateType, packageName, } = upgrade;
            const filteredUpgrade = {
                datasource,
                depName,
                displayPending,
                fixedVersion,
                currentVersion,
                currentValue,
                currentDigest,
                newValue,
                newVersion,
                newDigest,
                packageFile,
                updateType,
                packageName,
            };
            upgradesFiltered.push(filteredUpgrade);
        }
        const filteredBranch = {
            branchName,
            prNo,
            prTitle,
            result,
            prBlockedBy,
            upgrades: upgradesFiltered,
        };
        branchesFiltered.push(filteredBranch);
    }
    return branchesFiltered;
}
function runBranchSummary(config) {
    const defaultBranch = config.defaultBranch;
    const { scan, branches } = (0, repository_1.getCache)();
    const baseMetadata = [];
    for (const [branchName, cached] of Object.entries(scan ?? {})) {
        baseMetadata.push({ branchName, sha: cached.sha });
    }
    const branchMetadata = [];
    const inactiveBranches = [];
    for (const branch of branches ?? []) {
        if (branch.sha) {
            branchMetadata.push(branchCacheToMetadata(branch));
        }
        else {
            inactiveBranches.push(branch.branchName);
        }
    }
    const res = {
        cacheModified: (0, repository_1.isCacheModified)(),
        baseBranches: baseMetadata,
        branches: branchMetadata,
        defaultBranch,
        inactiveBranches,
    };
    logger_1.logger.debug(res, 'Branch summary');
    if (branches?.length) {
        const branchesInformation = filterDependencyDashboardData(branches);
        (0, reporting_1.addBranchStats)(config, branchesInformation);
        logger_1.logger.debug({ branchesInformation }, 'branches info extended');
    }
}
//# sourceMappingURL=repository-statistics.js.map