"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processSupersedesManagers = processSupersedesManagers;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const manager_1 = require("../../../modules/manager");
function processSupersedesManagers(extractResults) {
    for (const { manager, packageFiles } of extractResults) {
        if (!packageFiles) {
            continue;
        }
        const supersedesManagers = (0, manager_1.get)(manager, 'supersedesManagers');
        if (is_1.default.nonEmptyArray(supersedesManagers)) {
            const supercedingPackageFileNames = packageFiles.map((packageFile) => packageFile.packageFile);
            for (const supercededManager of supersedesManagers) {
                const supercededManagerResults = extractResults.find((result) => result.manager === supercededManager);
                if (supercededManagerResults?.packageFiles) {
                    supercededManagerResults.packageFiles =
                        supercededManagerResults.packageFiles.filter((packageFile) => {
                            if (!packageFile.lockFiles?.length &&
                                supercedingPackageFileNames.includes(packageFile.packageFile)) {
                                return false;
                            }
                            return true;
                        });
                }
            }
        }
    }
}
//# sourceMappingURL=supersedes.js.map