"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getManagerPackageFiles = getManagerPackageFiles;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const manager_1 = require("../../../modules/manager");
const fs_1 = require("../../../util/fs");
function massageDepNames(packageFiles) {
    if (packageFiles) {
        for (const packageFile of packageFiles) {
            for (const dep of packageFile.deps) {
                if (dep.packageName && !dep.depName) {
                    dep.depName = dep.packageName;
                }
            }
        }
    }
}
async function getManagerPackageFiles(config) {
    const { enabled, manager, fileList } = config;
    logger_1.logger.trace(`getPackageFiles(${manager})`);
    if (!enabled) {
        logger_1.logger.debug(`${manager} is disabled`);
        return [];
    }
    // istanbul ignore else
    if (is_1.default.nonEmptyArray(fileList)) {
        logger_1.logger.debug(`Matched ${fileList.length} file(s) for manager ${manager}: ${fileList.join(', ')}`);
    }
    else {
        return [];
    }
    // Extract package files synchronously if manager requires it
    if ((0, manager_1.get)(manager, 'extractAllPackageFiles')) {
        const allPackageFiles = await (0, manager_1.extractAllPackageFiles)(manager, config, fileList);
        massageDepNames(allPackageFiles);
        return allPackageFiles;
    }
    const packageFiles = [];
    for (const packageFile of fileList) {
        const content = await (0, fs_1.readLocalFile)(packageFile, 'utf8');
        // istanbul ignore else
        if (content) {
            const res = await (0, manager_1.extractPackageFile)(manager, content, packageFile, config);
            if (res) {
                packageFiles.push({
                    ...res,
                    packageFile,
                });
            }
        }
        else {
            logger_1.logger.debug(`${packageFile} has no content`);
        }
    }
    massageDepNames(packageFiles);
    return packageFiles;
}
//# sourceMappingURL=manager-files.js.map