"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateFingerprintConfig = generateFingerprintConfig;
const config_1 = require("../../../config");
const manager_1 = require("../../../modules/manager");
const custom_1 = require("../../../modules/manager/custom");
const utils_1 = require("../../../modules/manager/custom/utils");
// checks for regex manager fields
function getCustomManagerFields(config) {
    const regexFields = {};
    for (const field of utils_1.validMatchFields.map((f) => `${f}Template`)) {
        if (config[field]) {
            regexFields[field] = config[field];
        }
    }
    return {
        autoReplaceStringTemplate: config.autoReplaceStringTemplate,
        matchStrings: config.matchStrings,
        matchStringsStrategy: config.matchStringsStrategy,
        ...regexFields,
    };
}
function getFilteredManagerConfig(config) {
    return {
        ...((0, custom_1.isCustomManager)(config.manager) && getCustomManagerFields(config)),
        manager: config.manager,
        managerFilePatterns: config.managerFilePatterns,
        npmrc: config.npmrc,
        npmrcMerge: config.npmrcMerge,
        enabled: config.enabled,
        ignorePaths: config.ignorePaths ?? [],
        includePaths: config.includePaths ?? [],
        skipInstalls: config.skipInstalls,
        registryAliases: config.registryAliases,
        fileList: [],
    };
}
function generateFingerprintConfig(config) {
    const managerExtractConfigs = [];
    const managerList = new Set((0, manager_1.getEnabledManagersList)(config.enabledManagers));
    for (const manager of managerList) {
        const managerConfig = (0, config_1.getManagerConfig)(config, manager);
        if ((0, custom_1.isCustomManager)(manager)) {
            const filteredCustomManagers = (config.customManagers ?? []).filter((mgr) => mgr.customType === manager);
            for (const customManager of filteredCustomManagers) {
                managerExtractConfigs.push({
                    ...(0, config_1.mergeChildConfig)(managerConfig, customManager),
                    fileList: [],
                });
            }
        }
        else {
            managerExtractConfigs.push({ ...managerConfig, fileList: [] });
        }
    }
    return {
        managerList,
        managers: managerExtractConfigs.map(getFilteredManagerConfig),
    };
}
//# sourceMappingURL=extract-fingerprint-config.js.map