"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configMigration = configMigration;
const logger_1 = require("../../../logger");
const branch_1 = require("./branch");
const migrated_data_1 = require("./branch/migrated-data");
const pr_1 = require("./pr");
async function configMigration(config, branchList) {
    if (config.mode === 'silent') {
        logger_1.logger.debug('Config migration issues are not created, updated or closed when mode=silent');
        return { result: 'no-migration' };
    }
    const migratedConfigData = await migrated_data_1.MigratedDataFactory.getAsync();
    if (!migratedConfigData) {
        logger_1.logger.debug('Config does not need migration');
        migrated_data_1.MigratedDataFactory.reset();
        return { result: 'no-migration' };
    }
    const res = await (0, branch_1.checkConfigMigrationBranch)(config, migratedConfigData);
    // migration needed but not demanded by user
    if (res.result === 'no-migration-branch') {
        migrated_data_1.MigratedDataFactory.reset();
        return { result: 'add-checkbox' };
    }
    branchList.push(res.migrationBranch);
    const pr = await (0, pr_1.ensureConfigMigrationPr)(config, migratedConfigData);
    // only happens incase a migration pr was created by another user
    // for other cases in which a PR could not be found or created: we log warning and throw error from within the ensureConfigMigrationPr fn
    if (!pr) {
        migrated_data_1.MigratedDataFactory.reset();
        return { result: 'add-checkbox' };
    }
    migrated_data_1.MigratedDataFactory.reset();
    return {
        result: res.result === 'migration-branch-exists' ? 'pr-exists' : 'pr-modified',
        prNumber: pr.number,
    };
}
//# sourceMappingURL=index.js.map