"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigMigrationCommitMessageFactory = void 0;
const tslib_1 = require("tslib");
const template = tslib_1.__importStar(require("../../../../util/template"));
const commit_message_factory_1 = require("../../model/commit-message-factory");
class ConfigMigrationCommitMessageFactory {
    config;
    configFile;
    constructor(config, configFile) {
        this.config = config;
        this.configFile = configFile;
    }
    create(commitMessageTopic) {
        const { commitMessage } = this.config;
        const config = {
            ...this.config,
            semanticCommitScope: 'config',
            commitMessageExtra: '',
            commitMessageAction: '',
            commitMessageTopic,
        };
        const commitMessageFactory = new commit_message_factory_1.CommitMessageFactory(config);
        const commit = commitMessageFactory.create();
        if (commitMessage) {
            config.commitMessagePrefix = '';
            commit.subject = template.compile(commitMessage, config);
        }
        else {
            commit.subject = commitMessageTopic;
        }
        return commit;
    }
    getCommitMessage() {
        return this.create(`Migrate config ${this.configFile}`).toString();
    }
    getPrTitle() {
        return this.create(`Migrate renovate config`).toString();
    }
}
exports.ConfigMigrationCommitMessageFactory = ConfigMigrationCommitMessageFactory;
//# sourceMappingURL=commit-message.js.map