"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractRepoProblems = extractRepoProblems;
const bunyan_1 = require("bunyan");
const logger_1 = require("../../logger");
function extractRepoProblems(repository) {
    return new Set((0, logger_1.getProblems)()
        .filter((problem) => problem.repository === repository && !problem.artifactErrors)
        .map((problem) => `${bunyan_1.nameFromLevel[problem.level].toUpperCase()}: ${problem.msg}`));
}
//# sourceMappingURL=common.js.map