"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.embedChangelog = embedChangelog;
exports.embedChangelogs = embedChangelogs;
const tslib_1 = require("tslib");
const p = tslib_1.__importStar(require("../../../util/promises"));
const changelog_1 = require("../update/pr/changelog");
async function embedChangelog(upgrade) {
    // getChangeLogJSON returns null on error, so don't try again
    if (upgrade.logJSON !== undefined) {
        return;
    }
    if (upgrade.changelogContent === undefined) {
        upgrade.logJSON = await (0, changelog_1.getChangeLogJSON)(upgrade);
    }
    else {
        upgrade.logJSON = {
            hasReleaseNotes: true,
            project: {
                packageName: upgrade.packageName,
                depName: upgrade.depName,
                type: undefined,
                apiBaseUrl: undefined,
                baseUrl: undefined,
                repository: upgrade.repository,
                sourceUrl: upgrade.sourceUrl,
                sourceDirectory: upgrade.sourceDirectory,
            },
            versions: [
                {
                    changes: undefined,
                    compare: undefined,
                    date: undefined,
                    releaseNotes: {
                        body: upgrade.changelogContent,
                        notesSourceUrl: undefined,
                        url: upgrade.changelogUrl,
                    },
                    gitRef: undefined,
                    version: upgrade.newVersion,
                },
            ],
        };
    }
}
async function embedChangelogs(branches) {
    await p.map(branches, embedChangelog, { concurrency: 10 });
}
//# sourceMappingURL=index.js.map