"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCliName = getCliName;
exports.getConfig = getConfig;
const commander_1 = require("commander");
const options_1 = require("../../../../config/options");
const expose_cjs_1 = require("../../../../expose.cjs");
const logger_1 = require("../../../../logger");
const regex_1 = require("../../../../util/regex");
const coersions_1 = require("./coersions");
function getCliName(option) {
    if (option.cli === false) {
        return '';
    }
    const nameWithHyphens = option.name.replace((0, regex_1.regEx)(/([A-Z])/g), '-$1');
    return `--${nameWithHyphens.toLowerCase()}`;
}
function getConfig(input) {
    // massage migrated configuration keys
    const argv = input
        .map((a) => a
        .replace('--allow-post-upgrade-command-templating', '--allow-command-templating')
        .replace('--allowed-post-upgrade-commands', '--allowed-commands')
        .replace('--endpoints=', '--host-rules=')
        .replace('--expose-env=true', '--trust-level=high')
        .replace('--expose-env', '--trust-level=high')
        .replace('--renovate-fork', '--include-forks')
        .replace('"platform":"', '"hostType":"')
        .replace('"endpoint":"', '"matchHost":"')
        .replace('"host":"', '"matchHost":"')
        .replace('--azure-auto-complete', '--platform-automerge') // migrate: azureAutoComplete
        .replace('--git-lab-automerge', '--platform-automerge') // migrate: gitLabAutomerge
        .replace(/^--dry-run$/, '--dry-run=true')
        .replace(/^--require-config$/, '--require-config=true')
        .replace('--aliases', '--registry-aliases')
        .replace('--include-forks=true', '--fork-processing=enabled')
        .replace('--include-forks', '--fork-processing=enabled')
        .replace('--recreate-closed=false', '--recreate-when=auto')
        .replace('--recreate-closed=true', '--recreate-when=always')
        .replace('--recreate-closed', '--recreate-when=always'))
        .filter((a) => !a.startsWith('--git-fs'));
    const options = (0, options_1.getOptions)();
    const config = {};
    let program = new commander_1.Command().arguments('[repositories...]');
    options.forEach((option) => {
        if (option.cli !== false) {
            const param = `<${option.type}>`.replace('<boolean>', '[boolean]');
            const optionString = `${getCliName(option)} ${param}`;
            program = program.option(optionString, option.description, coersions_1.coersions[option.type]);
        }
    });
    /* eslint-disable no-console */
    /* istanbul ignore next */
    function helpConsole() {
        console.log('  Examples:');
        console.log('');
        console.log('    $ renovate --token 123test singapore/lint-condo');
        console.log('    $ LOG_LEVEL=debug renovate --labels=renovate,dependency --ignore-unstable=false singapore/lint-condo');
        console.log('    $ renovate singapore/lint-condo singapore/package-test');
        console.log(`    $ renovate singapore/lint-condo --onboarding-config='{"extends":["config:recommended"]}'`);
        /* eslint-enable no-console */
    }
    program = program
        .version(expose_cjs_1.pkg.version, '-v, --version')
        .on('--help', helpConsole)
        .action((repositories, opts) => {
        if (repositories?.length) {
            config.repositories = repositories;
        }
        for (const option of options) {
            if (option.cli !== false) {
                if (opts[option.name] !== undefined) {
                    config[option.name] = opts[option.name];
                    if (option.name === 'dryRun') {
                        if (config[option.name] === 'true') {
                            logger_1.logger.warn('cli config dryRun property has been changed to full');
                            config[option.name] = 'full';
                        }
                        else if (config[option.name] === 'false') {
                            logger_1.logger.warn('cli config dryRun property has been changed to null');
                            config[option.name] = null;
                        }
                        else if (config[option.name] === 'null') {
                            config[option.name] = null;
                        }
                    }
                    if (option.name === 'requireConfig') {
                        if (config[option.name] === 'true') {
                            logger_1.logger.warn('cli config requireConfig property has been changed to required');
                            config[option.name] = 'required';
                        }
                        else if (config[option.name] === 'false') {
                            logger_1.logger.warn('cli config requireConfig property has been changed to optional');
                            config[option.name] = 'optional';
                        }
                    }
                }
            }
        }
    })
        .parse(argv);
    return config;
}
//# sourceMappingURL=cli.js.map