import _parseLinkHeader from 'parse-link-header';
export declare function joinUrlParts(...parts: string[]): string;
export declare function ensurePathPrefix(url: string, prefix: string): string;
export declare function ensureTrailingSlash(url: string): string;
export declare function trimTrailingSlash(url: string): string;
export declare function trimLeadingSlash(path: string): string;
export declare function trimSlashes(path: string): string;
/**
 * Resolves an input path against a base URL
 *
 * @param baseUrl - base URL to resolve against
 * @param input - input path (if this is a full URL, it will be returned)
 */
export declare function resolveBaseUrl(baseUrl: string, input: string | URL): string;
/**
 * Replaces the path of a URL with a new path
 *
 * @param baseUrl - source URL
 * @param path - replacement path (if this is a full URL, it will be returned)
 */
export declare function replaceUrlPath(baseUrl: string | URL, path: string): string;
export declare function getQueryString(params: Record<string, any>): string;
export declare function isHttpUrl(url: unknown): boolean;
export declare function parseUrl(url: URL | string | undefined | null): URL | null;
/**
 * Tries to create an URL object from either a full URL string or a hostname
 * @param url either the full url or a hostname
 * @returns an URL object or null
 */
export declare function createURLFromHostOrURL(url: string): URL | null;
export type LinkHeaderLinks = _parseLinkHeader.Links;
export declare function parseLinkHeader(linkHeader: string | null | undefined): LinkHeaderLinks | null;
/**
 * prefix https:// to hosts with port or path
 */
export declare function massageHostUrl(url: string): string;
