export declare function matchAt(content: string, index: number, match: string): boolean;
export declare function replaceAt(content: string, index: number, oldString: string, newString: string): string;
/**
 * Converts from utf-8 string to base64-encoded string
 */
export declare function toBase64(input: string): string;
/**
 * Converts from base64-encoded string to utf-8 string
 */
export declare function fromBase64(input: string): string;
export declare function uniqueStrings(element: string, index: number, elements: string[]): boolean;
export declare function looseEquals(a: string | null | undefined, b: string | null | undefined): boolean;
export declare function titleCase(input: string): string;
/**
 * Sometimes we extract small strings from a multi-megabyte files.
 * If we then save them in the in-memory cache, V8 may not free
 * the initial buffer, which can lead to memory leaks:
 *
 *   https://bugs.chromium.org/p/v8/issues/detail?id=2869
 *
 */
export declare function copystr(x: string): string;
/**
 * Coerce a value to a string with optional default value.
 * @param val value to coerce
 * @returns the coerced value.
 */
export declare function coerceString(val: string | null | undefined, def?: string): string;
/**
 * Remove templates from string.
 *
 * This is more performant version of this code:
 *
 * ```
 *   content
 *     .replaceAll(regEx(/{{`.+?`}}/gs), '')
 *     .replaceAll(regEx(/{{.+?}}/gs), '')
 *     .replaceAll(regEx(/{%`.+?`%}/gs), '')
 *     .replaceAll(regEx(/{%.+?%}/gs), '')
 *     .replaceAll(regEx(/{#.+?#}/gs), '')
 * ```
 */
export declare function stripTemplates(content: string): string;
export declare function capitalize(input: string): string;
