"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toml = exports.MultidocYaml = exports.Yaml = exports.Jsonc = exports.Json5 = exports.Json = void 0;
const tslib_1 = require("tslib");
const json5_1 = tslib_1.__importDefault(require("json5"));
const v4_1 = require("zod/v4");
const common_1 = require("../common");
const toml_1 = require("../toml");
const yaml_1 = require("../yaml");
exports.Json = v4_1.z.string().transform((str, ctx) => {
    try {
        return JSON.parse(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid JSON' });
        return v4_1.z.NEVER;
    }
});
exports.Json5 = v4_1.z.string().transform((str, ctx) => {
    try {
        return json5_1.default.parse(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid JSON5' });
        return v4_1.z.NEVER;
    }
});
exports.Jsonc = v4_1.z.string().transform((str, ctx) => {
    try {
        return (0, common_1.parseJsonc)(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid JSONC' });
        return v4_1.z.NEVER;
    }
});
exports.Yaml = v4_1.z.string().transform((str, ctx) => {
    try {
        return (0, yaml_1.parseSingleYaml)(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid YAML' });
        return v4_1.z.NEVER;
    }
});
exports.MultidocYaml = v4_1.z.string().transform((str, ctx) => {
    try {
        return (0, yaml_1.parseYaml)(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid YAML' });
        return v4_1.z.NEVER;
    }
});
exports.Toml = v4_1.z.string().transform((str, ctx) => {
    try {
        return (0, toml_1.parse)(str);
    }
    catch {
        ctx.addIssue({ code: 'custom', message: 'Invalid TOML' });
        return v4_1.z.NEVER;
    }
});
//# sourceMappingURL=v4.js.map