"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getS3Client = getS3Client;
exports.parseS3Url = parseS3Url;
const tslib_1 = require("tslib");
// Singleton S3 instance initialized on-demand.
const client_s3_1 = require("@aws-sdk/client-s3");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const global_1 = require("../config/global");
const url_1 = require("./url");
let s3Instance;
function getS3Client(
// Only needed if GlobalConfig is not initialized due to some error
s3Endpoint, s3PathStyle) {
    if (!s3Instance) {
        const endpoint = s3Endpoint ?? global_1.GlobalConfig.get('s3Endpoint');
        const forcePathStyle = is_1.default.undefined(s3PathStyle)
            ? !!global_1.GlobalConfig.get('s3PathStyle')
            : s3PathStyle;
        s3Instance = new client_s3_1.S3Client({
            ...(endpoint && { endpoint }),
            ...(forcePathStyle && { forcePathStyle: true }),
        });
    }
    return s3Instance;
}
function parseS3Url(rawUrl) {
    const parsedUrl = typeof rawUrl === 'string' ? (0, url_1.parseUrl)(rawUrl) : rawUrl;
    if (parsedUrl === null) {
        return null;
    }
    if (parsedUrl.protocol !== 's3:') {
        return null;
    }
    return {
        Bucket: parsedUrl.host,
        Key: parsedUrl.pathname.substring(1),
    };
}
//# sourceMappingURL=s3.js.map