"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.newlineRegex = exports.regexEngineStatus = void 0;
exports.regEx = regEx;
exports.escapeRegExp = escapeRegExp;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const error_messages_1 = require("../constants/error-messages");
const expose_cjs_1 = require("../expose.cjs");
const env_1 = require("./env");
const cache = new Map();
let status;
let RegEx = RegExp;
/* v8 ignore next 2 */
if ((0, env_1.getEnv)().RENOVATE_X_IGNORE_RE2) {
    status = { type: 'ignored' };
}
else {
    try {
        const RE2 = (0, expose_cjs_1.re2)();
        // Test if native is working
        new RE2('.*').exec('test');
        RegEx = RE2;
        status = { type: 'available' };
    }
    catch (err) {
        status = { type: 'unavailable', err };
    }
}
exports.regexEngineStatus = status;
function regEx(pattern, flags, useCache = true) {
    let canBeCached = useCache;
    if (canBeCached && flags?.includes('g')) {
        canBeCached = false;
    }
    if (canBeCached && is_1.default.regExp(pattern) && pattern.flags.includes('g')) {
        canBeCached = false;
    }
    const key = flags ? `${pattern.toString()}:${flags}` : pattern.toString();
    if (canBeCached) {
        const cachedResult = cache.get(key);
        if (cachedResult) {
            return cachedResult;
        }
    }
    try {
        const instance = flags ? new RegEx(pattern, flags) : new RegEx(pattern);
        if (canBeCached) {
            cache.set(key, instance);
        }
        return instance;
    }
    catch (err) {
        const error = new Error(error_messages_1.CONFIG_VALIDATION);
        error.validationMessage = err.message;
        error.validationSource = pattern.toString();
        error.validationError = `Invalid regular expression (re2): ${pattern.toString()}`;
        throw error;
    }
}
function escapeRegExp(input) {
    return input.replace(regEx(/[.*+\-?^${}()|[\]\\]/g), '\\$&'); // $& means the whole matched string
}
exports.newlineRegex = regEx(/\r?\n/);
//# sourceMappingURL=regex.js.map