"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateTypesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class UpdateTypesMatcher extends base_1.Matcher {
    matches({ updateType, isBump }, { matchUpdateTypes }) {
        if (is_1.default.undefined(matchUpdateTypes)) {
            return null;
        }
        if (!updateType) {
            return false;
        }
        const toMatch = [updateType];
        if (isBump) {
            toMatch.push('bump');
        }
        return (0, string_match_1.anyMatchRegexOrGlobList)(toMatch, matchUpdateTypes);
    }
}
exports.UpdateTypesMatcher = UpdateTypesMatcher;
//# sourceMappingURL=update-types.js.map