"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceUrlsMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class SourceUrlsMatcher extends base_1.Matcher {
    matches({ sourceUrl }, { matchSourceUrls }) {
        if (is_1.default.undefined(matchSourceUrls)) {
            return null;
        }
        if (!sourceUrl) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(sourceUrl, matchSourceUrls);
    }
}
exports.SourceUrlsMatcher = SourceUrlsMatcher;
//# sourceMappingURL=sourceurls.js.map