"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageNameMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class PackageNameMatcher extends base_1.Matcher {
    matches({ packageName }, packageRule) {
        const { matchPackageNames } = packageRule;
        if (is_1.default.undefined(matchPackageNames)) {
            return null;
        }
        if (!packageName) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(packageName, matchPackageNames);
    }
}
exports.PackageNameMatcher = PackageNameMatcher;
//# sourceMappingURL=package-names.js.map