"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewValueMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class NewValueMatcher extends base_1.Matcher {
    matches({ newValue }, { matchNewValue }) {
        if (is_1.default.undefined(matchNewValue)) {
            return null;
        }
        const matchNewValuePred = (0, string_match_1.getRegexOrGlobPredicate)(matchNewValue);
        if (!newValue) {
            return false;
        }
        return matchNewValuePred(newValue);
    }
}
exports.NewValueMatcher = NewValueMatcher;
//# sourceMappingURL=new-value.js.map