"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_branches_1 = require("./base-branches");
const categories_1 = require("./categories");
const current_age_1 = require("./current-age");
const current_value_1 = require("./current-value");
const current_version_1 = require("./current-version");
const datasources_1 = require("./datasources");
const dep_names_1 = require("./dep-names");
const dep_types_1 = require("./dep-types");
const files_1 = require("./files");
const jsonata_1 = require("./jsonata");
const managers_1 = require("./managers");
const merge_confidence_1 = require("./merge-confidence");
const new_value_1 = require("./new-value");
const package_names_1 = require("./package-names");
const repositories_1 = require("./repositories");
const sourceurls_1 = require("./sourceurls");
const update_types_1 = require("./update-types");
const matchers = [];
exports.default = matchers;
// Each matcher under the same index will use a logical OR, if multiple matchers are applied AND will be used
// applyPackageRules evaluates matchers in the order of insertion and returns early on failure.
// Therefore, when multiple matchers are set in a single packageRule, some may not be checked.
// Since matchConfidence matcher can abort the run due to unauthenticated use, it should be evaluated first.
matchers.push(new merge_confidence_1.MergeConfidenceMatcher());
matchers.push(new repositories_1.RepositoriesMatcher());
matchers.push(new base_branches_1.BaseBranchesMatcher());
matchers.push(new categories_1.CategoriesMatcher());
matchers.push(new managers_1.ManagersMatcher());
matchers.push(new files_1.FileNamesMatcher());
matchers.push(new datasources_1.DatasourcesMatcher());
matchers.push(new package_names_1.PackageNameMatcher());
matchers.push(new dep_names_1.DepNameMatcher());
matchers.push(new dep_types_1.DepTypesMatcher());
matchers.push(new current_value_1.CurrentValueMatcher());
matchers.push(new current_version_1.CurrentVersionMatcher());
matchers.push(new update_types_1.UpdateTypesMatcher());
matchers.push(new sourceurls_1.SourceUrlsMatcher());
matchers.push(new new_value_1.NewValueMatcher());
matchers.push(new current_age_1.CurrentAgeMatcher());
matchers.push(new jsonata_1.JsonataMatcher());
//# sourceMappingURL=matchers.js.map