"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagersMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const custom_1 = require("../../modules/manager/custom");
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class ManagersMatcher extends base_1.Matcher {
    matches({ manager }, { matchManagers }) {
        if (is_1.default.undefined(matchManagers)) {
            return null;
        }
        if (is_1.default.undefined(manager) || !manager) {
            return false;
        }
        if ((0, custom_1.isCustomManager)(manager)) {
            return (0, string_match_1.matchRegexOrGlobList)(`custom.${manager}`, matchManagers);
        }
        return (0, string_match_1.matchRegexOrGlobList)(manager, matchManagers);
    }
}
exports.ManagersMatcher = ManagersMatcher;
//# sourceMappingURL=managers.js.map