"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileNamesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class FileNamesMatcher extends base_1.Matcher {
    matches({ packageFile, lockFiles }, { matchFileNames }) {
        if (is_1.default.undefined(matchFileNames)) {
            return null;
        }
        if (is_1.default.undefined(packageFile)) {
            return false;
        }
        if ((0, string_match_1.matchRegexOrGlobList)(packageFile, matchFileNames)) {
            return true;
        }
        if (is_1.default.array(lockFiles)) {
            return (0, string_match_1.anyMatchRegexOrGlobList)(lockFiles, matchFileNames);
        }
        return false;
    }
}
exports.FileNamesMatcher = FileNamesMatcher;
//# sourceMappingURL=files.js.map