"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DepTypesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class DepTypesMatcher extends base_1.Matcher {
    matches({ depTypes, depType }, { matchDepTypes }) {
        if (is_1.default.undefined(matchDepTypes)) {
            return null;
        }
        if (depType) {
            return (0, string_match_1.matchRegexOrGlobList)(depType, matchDepTypes);
        }
        if (depTypes) {
            return (0, string_match_1.anyMatchRegexOrGlobList)(depTypes, matchDepTypes);
        }
        return false;
    }
}
exports.DepTypesMatcher = DepTypesMatcher;
//# sourceMappingURL=dep-types.js.map