"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatasourcesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class DatasourcesMatcher extends base_1.Matcher {
    matches({ datasource }, { matchDatasources }) {
        if (is_1.default.undefined(matchDatasources)) {
            return null;
        }
        if (is_1.default.undefined(datasource)) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(datasource, matchDatasources);
    }
}
exports.DatasourcesMatcher = DatasourcesMatcher;
//# sourceMappingURL=datasources.js.map