"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoriesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class CategoriesMatcher extends base_1.Matcher {
    matches({ categories }, { matchCategories }) {
        if (is_1.default.nullOrUndefined(matchCategories)) {
            return null;
        }
        if (is_1.default.nullOrUndefined(categories)) {
            return false;
        }
        return (0, string_match_1.anyMatchRegexOrGlobList)(categories, matchCategories);
    }
}
exports.CategoriesMatcher = CategoriesMatcher;
//# sourceMappingURL=categories.js.map