import type { AllConfig, UpdateType } from '../../config/types';
import type { MergeConfidence } from './types';
export declare const confidenceLevels: Record<MergeConfidence, number>;
export declare function initConfig({ mergeConfidenceEndpoint, mergeConfidenceDatasources, }: AllConfig): void;
export declare function resetConfig(): void;
export declare function isMergeConfidence(value: string): value is MergeConfidence;
export declare function isActiveConfidenceLevel(confidence: string): boolean;
export declare function satisfiesConfidenceLevel(confidence: MergeConfidence, minimumConfidence: MergeConfidence): boolean;
/**
 * Retrieves the merge confidence of a package update if the merge confidence API is enabled. Otherwise, undefined is returned.
 *
 * @param datasource
 * @param packageName
 * @param currentVersion
 * @param newVersion
 * @param updateType
 *
 * @returns The merge confidence level for the given package release.
 * @throws {ExternalHostError} If a request has been made and an error occurs during the request, such as a timeout, connection reset, authentication failure, or internal server error.
 */
export declare function getMergeConfidenceLevel(datasource: string, packageName: string, currentVersion: string, newVersion: string, updateType: UpdateType): Promise<MergeConfidence | undefined>;
/**
 * Checks the health of the Merge Confidence API by attempting to authenticate with it.
 *
 * @returns Resolves when the API health check is completed successfully.
 *
 * @throws {ExternalHostError} if a timeout, connection reset error, authentication failure, or internal server error occurs during the request.
 *
 * @remarks
 * This function first checks that the API base URL and an authentication bearer token are defined before attempting to
 * authenticate with the API. If either the base URL or token is not defined, it will immediately return
 * without making a request.
 */
export declare function initMergeConfidence(config: AllConfig): Promise<void>;
export declare function getApiToken(): string | undefined;
