"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExpression = getExpression;
const tslib_1 = require("tslib");
const jsonata_1 = tslib_1.__importDefault(require("jsonata"));
const memCache = tslib_1.__importStar(require("./cache/memory"));
const hash_1 = require("./hash");
function getExpression(input) {
    const cacheKey = `jsonata:${(0, hash_1.toSha256)(input)}`;
    const cachedExpression = memCache.get(cacheKey);
    // istanbul ignore if: cannot test
    if (cachedExpression) {
        return cachedExpression;
    }
    let result;
    try {
        result = (0, jsonata_1.default)(input);
    }
    catch (err) {
        // JSONata errors aren't detected as TypeOf Error
        result = new Error(err.message);
    }
    memCache.set(cacheKey, result);
    return result;
}
//# sourceMappingURL=jsonata.js.map