"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONWriter = void 0;
class JSONWriter {
    indentationType;
    indentationSize;
    constructor(codeFormat = {}) {
        this.indentationSize = codeFormat.indentationSize ?? 2;
        this.indentationType = codeFormat.indentationType ?? 'space';
    }
    write(json, newLineAtTheEnd = true) {
        let content = JSON.stringify(json, null, this.indentation);
        if (newLineAtTheEnd) {
            content = content.concat('\n');
        }
        return content;
    }
    get indentation() {
        if (this.indentationType === 'tab') {
            return '\t';
        }
        return this.indentationSize;
    }
}
exports.JSONWriter = JSONWriter;
//# sourceMappingURL=json-writer.js.map