"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSkipComment = isSkipComment;
const logger_1 = require("../logger");
const regex_1 = require("./regex");
function isSkipComment(comment) {
    if (comment && (0, regex_1.regEx)(/^(renovate|pyup):/).test(comment)) {
        const command = comment.split('#')[0].split(':')[1].trim();
        if (command === 'ignore') {
            return true;
        }
        logger_1.logger.debug('Unknown comment command: ' + command);
    }
    return false;
}
//# sourceMappingURL=ignore.js.map